<?php $__env->startSection('main-container'); ?>
  <style>
      .table th,
      .table td {
          padding: 0.25rem;
      }

      .select2-container .select2-selection--single {
          height: auto !important;
      }

      .select2-container .select2-selection--single .select2-selection__rendered {
          padding-top: .25rem !important;
          padding-bottom: .25rem !important;
          font-size: .875rem !important;
      }

      .select2-container--default .select2-selection--single .select2-selection__arrow {
          top: 3px !important;
          right: 3px !important;
      }

      .select2-container--default .select2-selection--single .select2-selection__rendered {
          line-height: 1.5 !important;
      }
  </style>

  <div>
    <?php if(Session::has('success')): ?>
        <div class="alert alert-success alert-dismissible my-1" role="alert">
            <button type="button" class="close" data-bs-dismiss="alert">
                <i class="fa fa-times"></i>
            </button>
            <strong>Success !</strong> <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger alert-dismissible my-1" role="alert">
            <button type="button" class="close" data-bs-dismiss="alert">
                <i class="fa fa-times"></i>
            </button>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <strong>Error !</strong> <?php echo e($error); ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>
  </div>

  <div class="main_content_iner">
    <div class="container-fluid p-0">
      <div class="row justify-content-center">
        <div class="">
          <div class="px-4 py-1 theme_bg_1 d-flex justify-content-between">
              <h5 class="mb-0 text-white text-center">Services</h5>
              <a class="btn-custom-1" href="#" data-bs-toggle="modal" data-bs-target="#addServiceModal">Add</a>
          </div>
        </div>

        
        <div class="modal fade" id="addServiceModal" tabindex="-1"
          aria-labelledby="addServiceModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-xl">
            <div class="modal-content">
              <div class="modal-header" style="background: #2d1967; padding: 0.8rem 1rem;">
                <h1 class="modal-title fs-5 text-white" id="addServiceModalLabel">Add New Service</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal"
                  aria-label="Close" style="filter: invert(100%);"></button>
              </div>
              <form method="POST" action="<?php echo e(route('services.store')); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                  
                  <fieldset class="border rounded-3 p-3 theme-border mb-5">
                    <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Service Information</legend>
                    <div class="row">
                      <div class="col-sm-4">
                        <div class="mb-2">
                          <label for="customer_id" class="form-label fw-bold">Customers Name</label>
                          <select class="select2 form-select form-select-sm" style="width: 100% !important;" id="customer_id" name="customer_id">
                            <option selected>Select a Customer</option>
                            <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($customer->id); ?>"><?php echo e($customer->customer_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                      </div>
                      <div class="col-sm-4">
                        <div class="mb-2">
                          <label for="srv_type_id" class="form-label fw-bold">Service Type</label>
                          <select onchange="addServices(this)" name="srv_type_id" id="srv_type_id" class="form-control form-select-sm">
                            <option value="">Select a Service</option>
                            <?php $__currentLoopData = $service_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $srv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option <?php echo e(($srv->id == 1) ? "selected" : ""); ?> value="<?php echo e($srv->id); ?>"><?php echo e($srv->srv_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </select>
                        </div>
                      </div>
                    </div>
                  </fieldset>

                  
                  <fieldset class="border rounded-3 p-3 theme-border" id="add_data">
                    <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Data Service/Other Service</legend>
                    
                    <fieldset class="border rounded-3 p-3 theme-border mb-5">
                      <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Service Info</legend>
                      <div class="row">
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="link_from" class="form-label fw-bold">Link From</label>
                            <input type="text" class="form-control" id="link_from" name="link_from">
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="link_to" class="form-label fw-bold">Link To</label>
                            <input type="text" class="form-control" id="link_to" name="link_to">
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="bandwidth" class="form-label fw-bold">Bandwidth Capacity(K)</label>
                            <input type="text" class="form-control" id="bandwidth" name="bandwidth">
                          </div>
                        </div>
                      </div>

                      <div class="row">
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="unit_id" class="form-label fw-bold">Unit</label>
                            <select name="unit_id" id="unit_id" class="form-control">
                              <option value="">Select an Unit</option>
                              <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($unit->id); ?>"><?php echo e($unit->unit_display); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="unit_qty" class="form-label fw-bold">Quantity</label>
                            <input type="number" class="form-control" id="unit_qty" name="unit_qty">
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="vat_rate" class="form-label fw-bold">VAT(%)</label>
                            <input type="number" class="form-control" id="vat_rate" name="vat_rate">
                          </div>
                        </div>
                      </div>

                      <div class="row">
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="rate_amnt" class="form-label fw-bold">Contact Amount</label>
                            <input type="number" class="form-control" id="rate_amnt" name="rate_amnt">
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="vat_amnt" class="form-label fw-bold">VAT Amount</label>
                            <input type="number" class="form-control" id="vat_amnt" name="vat_amnt">
                          </div>
                        </div>
                      </div>
                    </fieldset>

                    
                    <fieldset class="border rounded-3 p-3 theme-border">
                      <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Billing Info</legend>
                      <div class="row">
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="monthly_bill_data" class="form-label fw-bold">Monthly Bill </label>
                            <input type="text" class="form-control" id="monthly_bill_data" name="monthly_bill_data">
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <br>
                          <div class="mt-3">
                            <input type="hidden" name="include_vat_data" value="0">
                            <input type="checkbox" class="form-check-input" id="include_vat_data" name="include_vat_data" value="1" checked>
                            <label for="include_vat_data" class="form-label fw-bold ms-1">Include VAT </label>
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="bill_start_date_data" class="form-label fw-bold">Bill Start Date</label>
                            <input type="text" class="form-control datepicker-here digits" id="bill_start_date_data" name="bill_start_date_data">
                          </div>
                        </div>
                      </div>

                      <div class="row">
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="tbl_bill_type_id_data" class="form-label fw-bold">Bill Type</label>
                            <select name="tbl_bill_type_id_data" id="tbl_bill_type_id_data" class="form-control">
                              <option value="">Select a Bill Type</option>
                              <?php $__currentLoopData = $bill_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bill_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($bill_type->id); ?>"><?php echo e($bill_type->bill_type_name); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="tbl_status_type_id_data" class="form-label fw-bold">Service Status </label>
                            <select name="tbl_status_type_id_data" id="tbl_status_type_id_data" class="form-control">
                              <option value="">Select a Service Status</option>
                              <?php $__currentLoopData = $status_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($status_type->id); ?>"><?php echo e($status_type->inv_name); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="remarks_data" class="form-label fw-bold">Remarks / Special Note </label>
                            <textarea class="form-control" id="remarks_data" name="remarks_data" rows="1"></textarea>
                          </div>
                        </div>
                      </div>

                      <div class="row">
                        <div class="col-sm-4">
                          <br>
                          <div class="mt-3">
                            <input type="hidden" name="greeting_sms_sent_data" value="0">
                            <input type="checkbox" class="form-check-input" id="greeting_sms_sent_data" name="greeting_sms_sent_data" value="1">
                            <label for="greeting_sms_sent_data" class="form-label fw-bold ms-1">Send Greeting SMS? </label>
                          </div>
                        </div>
                      </div>
                    </fieldset>
                  </fieldset>

                  
                  <fieldset class="border rounded-3 p-3 theme-border d-none" id="add_broadband">
                    <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Broadband</legend>
                    
                    <fieldset class="border rounded-3 p-3 theme-border mb-5">
                      <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Service Info</legend>
                      <div class="row">
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="user_id" class="form-label fw-bold">Customer ID</label>
                            <input type="text" class="form-control" id="user_id" name="user_id">
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="password" class="form-label fw-bold">Password </label>
                            <input type="password" class="form-control" id="password" name="password">
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="bandwidth_plan_id" class="form-label fw-bold">Connection Type </label>
                            <select name="bandwidth_plan_id" id="bandwidth_plan_id" class="form-control">
                              <option value="">Select a Connection Type</option>
                              <?php $__currentLoopData = $bandwidth_plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bandwidth_plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($bandwidth_plan->id); ?>"><?php echo e($bandwidth_plan->bandwidth_plan); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                          </div>
                        </div>
                      </div>

                      <div class="row">
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="installation_date" class="form-label fw-bold">Installation Date </label>
                            <input type="text" class="form-control datepicker-here digits" id="installation_date" name="installation_date">
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="remarks_broadband" class="form-label fw-bold">Remarks / Special Note </label>
                            <textarea class="form-control" id="remarks_broadband" name="remarks_broadband" rows="1"></textarea>
                          </div>
                        </div>
                      </div>
                    </fieldset>
                  
                    
                    <fieldset class="border rounded-3 p-3 theme-border mb-5">
                      <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Connection Info</legend>
                      <div class="row">
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="type_of_connectivity" class="form-label fw-bold">Type of Connectivity</label>
                            <select name="type_of_connectivity" id="type_of_connectivity" class="form-control">
                              <option value="">Select a Connectivity</option>
                              <?php $__currentLoopData = $cable_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cable_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($cable_type->id); ?>"><?php echo e($cable_type->cable_type); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="router_id" class="form-label fw-bold">Router</label>
                            <select name="router_id" id="router_id" class="form-control">
                              <option value="">Select a Router</option>
                              <?php $__currentLoopData = $routers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $router): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($router->id); ?>"><?php echo e($router->router_name); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="device" class="form-label fw-bold">Device </label>
                            <input type="text" class="form-control" id="device" name="device">
                          </div>
                        </div>
                      </div>

                      <div class="row">
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="mac_address" class="form-label fw-bold">Device MAC </label>
                            <input type="text" class="form-control" id="mac_address" name="mac_address">
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="ip_number" class="form-label fw-bold">IP Number</label>
                            <input type="text" class="form-control" id="ip_number" name="ip_number">
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="box_id" class="form-label fw-bold">Box </label>
                            <select name="box_id" id="box_id" class="form-control">
                              <option value="">Select a Box</option>
                              <?php $__currentLoopData = $boxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $box): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($box->id); ?>"><?php echo e($box->box_name); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                          </div>
                        </div>
                      </div>

                      <div class="row">
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="cable_req" class="form-label fw-bold">Cable req </label>
                            <input type="text" class="form-control" id="cable_req" name="cable_req">
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="no_of_core" class="form-label fw-bold">No. of Core </label>
                            <input type="text" class="form-control" id="no_of_core" name="no_of_core">
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="core_color" class="form-label fw-bold">Core Color</label>
                            <input type="text" class="form-control" id="core_color" name="core_color">
                          </div>
                        </div>
                      </div>

                      <div class="row">
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="fiber_code" class="form-label fw-bold">Fiber Code </label>
                            <input type="text" class="form-control" id="fiber_code" name="fiber_code">
                          </div>
                        </div>
                      </div>
                    </fieldset>

                    
                    <fieldset class="border rounded-3 p-3 theme-border">
                      <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Billing Info</legend>
                      <div class="row">
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="tbl_bill_type_id_broadband" class="form-label fw-bold">Bill Type</label>
                            <select name="tbl_bill_type_id_broadband" id="tbl_bill_type_id_broadband" class="form-control">
                              <option value="">Select a Bill Type</option>
                              <?php $__currentLoopData = $bill_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bill_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($bill_type->id); ?>"><?php echo e($bill_type->bill_type_name); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="invoice_type_id" class="form-label fw-bold">Invoice Type </label>
                            <select name="invoice_type_id" id="invoice_type_id" class="form-control" disabled>
                              <option value="">Select an Invoice Type</option>
                              <?php $__currentLoopData = $invoice_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option <?php echo e(($invoice_type->id == "1") ? "selected" : ""); ?> value="<?php echo e($invoice_type->id); ?>"><?php echo e($invoice_type->invoice_type_name); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="bill_start_date_broadband" class="form-label fw-bold">Bill Start Date</label>
                            <input type="text" class="form-control datepicker-here digits" id="bill_start_date_broadband" name="bill_start_date_broadband">
                          </div>
                        </div>
                      </div>

                      <div class="row">
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="tbl_client_type_id" class="form-label fw-bold">Package</label>
                            <select name="tbl_client_type_id" id="tbl_client_type_id" class="form-control">
                              <option value="">Select a Package</option>
                              <?php $__currentLoopData = $client_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($client_type->id); ?>"><?php echo e($client_type->name); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="monthly_bill_broadband" class="form-label fw-bold">Monthly Bill </label>
                            <input type="text" class="form-control" id="monthly_bill_broadband" name="monthly_bill_broadband">
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="billing_status_id" class="form-label fw-bold">Billing Status </label>
                            <select name="billing_status_id" id="billing_status_id" class="form-control">
                              <option value="">Select Billing Status</option>
                              <?php $__currentLoopData = $billing_statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $billing_status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($billing_status->id); ?>"><?php echo e($billing_status->billing_status_name); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                          </div>
                        </div>
                      </div>

                      <div class="row">
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="tbl_status_type_id_broadband" class="form-label fw-bold">Service Status </label>
                            <select name="tbl_status_type_id_broadband" id="tbl_status_type_id_broadband" class="form-control">
                              <option value="">Select a Service Status</option>
                              <?php $__currentLoopData = $status_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($status_type->id); ?>"><?php echo e($status_type->inv_name); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <br>
                          <div class="mt-3">
                            <input type="hidden" name="include_vat_broadband" value="0">
                            <input type="checkbox" class="form-check-input" id="include_vat_broadband" name="include_vat_broadband" value="1" checked>
                            <label for="include_vat_broadband" class="form-label fw-bold ms-1">Include VAT </label>
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <br>
                          <div class="mt-3">
                            <input type="hidden" name="greeting_sms_sent_broadband" value="0">
                            <input type="checkbox" class="form-check-input" id="greeting_sms_sent_broadband" name="greeting_sms_sent_broadband" value="1">
                            <label for="greeting_sms_sent_broadband" class="form-label fw-bold ms-1">Send Greeting SMS? </label>
                          </div>
                        </div>
                      </div>
                    </fieldset>
                  </fieldset>
                  
                  
                  <fieldset class="border rounded-3 p-3 theme-border d-none" id="add_cable_tv">
                    <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Cable TV</legend>
                    
                    <fieldset class="border rounded-3 p-3 theme-border mb-5">
                      <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Service Info</legend>
                      <div class="row">
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="number_of_tv" class="form-label fw-bold">Number of TV</label>
                            <input type="text" class="form-control" id="number_of_tv" name="number_of_tv">
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="number_of_channel" class="form-label fw-bold">Number of Channel</label>
                            <input type="text" class="form-control" id="number_of_channel" name="number_of_channel">
                          </div>
                        </div>
                      </div>
                    </fieldset>

                    
                    <fieldset class="border rounded-3 p-3 theme-border">
                      <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Billing Info</legend>
                      <div class="row">
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="monthly_bill_cable" class="form-label fw-bold">Monthly Bill </label>
                            <input type="text" class="form-control" id="monthly_bill_cable" name="monthly_bill_cable">
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <br>
                          <div class="mt-3">
                            <input type="hidden" name="include_vat_cable" value="0">
                            <input type="checkbox" class="form-check-input" id="include_vat_cable" name="include_vat_cable" value="1" checked>
                            <label for="include_vat_cable" class="form-label fw-bold ms-1">Include VAT </label>
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="bill_start_date_cable" class="form-label fw-bold">Bill Start Date</label>
                            <input type="text" class="form-control datepicker-here digits" id="bill_start_date_cable" name="bill_start_date_cable">
                          </div>
                        </div>
                      </div>

                      <div class="row">
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="tbl_bill_type_id_cable" class="form-label fw-bold">Bill Type</label>
                            <select name="tbl_bill_type_id_cable" id="tbl_bill_type_id_cable" class="form-control">
                              <option value="">Select a Bill Type</option>
                              <?php $__currentLoopData = $bill_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bill_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($bill_type->id); ?>"><?php echo e($bill_type->bill_type_name); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="tbl_status_type_id_cable" class="form-label fw-bold">Service Status </label>
                            <select name="tbl_status_type_id_cable" id="tbl_status_type_id_cable" class="form-control">
                              <option value="">Select a Service Status</option>
                              <?php $__currentLoopData = $status_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($status_type->id); ?>"><?php echo e($status_type->inv_name); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                          </div>
                        </div>
                        <div class="col-sm-4">
                          <div class="mb-2">
                            <label for="remarks_cable" class="form-label fw-bold">Remarks / Special Note </label>
                            <textarea class="form-control" id="remarks_cable" name="remarks_cable" rows="1"></textarea>
                          </div>
                        </div>
                      </div>

                      <div class="row">
                        <div class="col-sm-4">
                          <br>
                          <div class="mt-3">
                            <input type="hidden" name="greeting_sms_sent_cable" value="0">
                            <input type="checkbox" class="form-check-input" id="greeting_sms_sent_cable" name="greeting_sms_sent_cable" value="1">
                            <label for="greeting_sms_sent_cable" class="form-label fw-bold ms-1">Send Greeting SMS? </label>
                          </div>
                        </div>
                      </div>
                    </fieldset>
                  </fieldset>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal" aria-label="Close">Cancel</button>
                  <button class="btn btn-sm btn-primary" type="submit" onclick="this.disabled=true;this.form.submit();">Submit</button>
                </div>
              </form>
            </div>
          </div>
        </div>

        <div class="col-sm-12">
          <div class="p-3">
            <div class="row">
              <div class="col-sm-4 form-group">
                <label for="customer" class="fw-bold">Customer</label>
                <select class="select2 form-select form-select-sm id="customer" name="customer">
                  <option selected>Select a Customer</option>
                  <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <option value="<?php echo e($customer->id); ?>"><?php echo e($customer->customer_name); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
              
              <div class="col-sm-4 form-group">
                <label for="tbl_status_type_id" class="fw-bold">Customer Status</label>
                <select class="select2 form-select form-select-sm" id="tbl_status_type_id" name="tbl_status_type_id">
                  <option selected>Select a Customer Status</option>
                  <?php $__currentLoopData = $status_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <option value="<?php echo e($status_type->id); ?>"><?php echo e($status_type->inv_name); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
              
              <div class="col-sm-2 d-flex d-sm-inline justify-content-end">
                <br class="d-none d-sm-block">
                <button class="btn btn-sm btn-success">Search</button>    
              </div>
            </div>

            <div class="QA_table pb-0">
              <table class="table datatable compact">
                <thead>
                  <tr>
                    <th scope="col">Sl</th>
                    <th scope="col">Client Name</th>
                    <th scope="col">Service Type</th>
                    <th scope="col">Link From</th>
                    <th scope="col">Link To</th>
                    <th scope="col">Unit</th>
                    <th scope="col">Quantity</th>
                    <th scope="col">Status</th>
                    <th scope="col">Bill Type</th>
                    <th scope="col">Bill Start Date</th>
                    <th scope="col">Action</th>
                  </tr>
                </thead>

                <tbody>
                  <?php $slNumber = 1 ?>
                  
                  <?php $__currentLoopData = $client_services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    
                    <tr>
                      <td style="color: black; font-size: small;"><?php echo e($slNumber++); ?></td>
                      <td style="color: black; font-size: small;"><?php echo e($service->customer_name); ?></td>
                      <td style="color: black; font-size: small;"><?php echo e($service->srv_name); ?></td>
                      <td style="color: black; font-size: small;"><?php echo e($service->link_from); ?></td>
                      <td style="color: black; font-size: small;"><?php echo e($service->link_to); ?></td>
                      <td style="color: black; font-size: small;"><?php echo e($service->unit_display); ?></td>
                      <td style="color: black; font-size: small;"><?php echo e($service->unit_qty); ?></td>
                      <td style="color: black; font-size: small;"><?php echo e($service->inv_name); ?></td>
                      <td style="color: black; font-size: small;"><?php echo e($service->bill_type_name); ?></td>
                      <td style="color: black; font-size: small;"><?php echo e($service->bill_start_date); ?></td>
                      <td>
                          <div class="btn-group">
                            <button type="button" class="btn btn-sm btn-primary dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                              Action
                            </button>
                            <div class="dropdown-menu">
                              <a class="dropdown-item" onclick="editServices(<?php echo e($service->srv_type_id); ?>)" href="#" data-bs-toggle="modal" data-bs-target="#editServiceModal<?php echo e($service->id); ?>">Edit</a>
                              <a class="dropdown-item" href="#" onclick="window.print()">Print</a>
                            </div>
                          </div>
                      </td>
                    </tr>

                    
                    <div class="modal fade" id="editServiceModal<?php echo e($service->id); ?>" tabindex="-1"
                      aria-labelledby="editServiceModalLabel<?php echo e($service->id); ?>" aria-hidden="true">
                      <div class="modal-dialog modal-xl">
                        <div class="modal-content">
                          <div class="modal-header" style="background: #2d1967; padding: 0.8rem 1rem;">
                            <h1 class="modal-title fs-5 text-white" id="editServiceModalLabel<?php echo e($service->id); ?>">Edit Service</h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                              aria-label="Close" style="filter: invert(100%);"></button>
                          </div>
                          <form method="POST" action="<?php echo e(route('services.update', ['service' => $service->id])); ?>">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <div class="modal-body">
                              
                              <fieldset class="border rounded-3 p-3 theme-border mb-5">
                                <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Service Information</legend>
                                <div class="row">
                                  <div class="col-sm-4">
                                    <div class="mb-2">
                                      <label for="customer_id" class="form-label fw-bold">Customers Name</label>
                                      <select class="select2 form-select form-select-sm" style="width: 100% !important;" id="customer_id" name="customer_id">
                                        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(($service->customer_id == $customer->id) ? "selected" : ""); ?> value="<?php echo e($customer->id); ?>"><?php echo e($customer->customer_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                  </div>
                                  <div class="col-sm-4">
                                    <div class="mb-2">
                                      <label for="srv_type_id" class="form-label fw-bold">Service Type</label>
                                      <select onchange="editServices(<?php echo e($service->srv_type_id); ?>)" name="srv_type_id" id="srv_type_id<?php echo e($service->srv_type_id); ?>" class="form-control form-select-sm">
                                        <?php $__currentLoopData = $service_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $srv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(($service->srv_type_id == $srv->id) ? "selected" : ""); ?> value="<?php echo e($srv->id); ?>"><?php echo e($srv->srv_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                      </select>
                                    </div>
                                  </div>
                                </div>
                              </fieldset>

                              
                              <fieldset class="border rounded-3 p-3 theme-border d-none" id="edit_data<?php echo e($service->srv_type_id); ?>">
                                <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Data Service/Other Service</legend>
                                
                                <fieldset class="border rounded-3 p-3 theme-border mb-5">
                                  <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Service Info</legend>
                                  <div class="row">
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="link_from" class="form-label fw-bold">Link From</label>
                                        <input type="text" class="form-control" id="link_from" name="link_from" value="<?php echo e($service->link_from); ?>">
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="link_to" class="form-label fw-bold">Link To</label>
                                        <input type="text" class="form-control" id="link_to" name="link_to" value="<?php echo e($service->link_to); ?>">
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="bandwidth" class="form-label fw-bold">Bandwidth Capacity(K)</label>
                                        <input type="text" class="form-control" id="bandwidth" name="bandwidth" value="<?php echo e($service->bandwidth); ?>">
                                      </div>
                                    </div>
                                  </div>

                                  <div class="row">
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="unit_id" class="form-label fw-bold">Unit</label>
                                        <select name="unit_id" id="unit_id" class="form-control">
                                          <option value="">Select a Unit</option>
                                          <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                              <option <?php echo e(($service->unit_id == $unit->id) ? "selected" : ""); ?> value="<?php echo e($unit->id); ?>"><?php echo e($unit->unit_display); ?></option>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="unit_qty" class="form-label fw-bold">Quantity</label>
                                        <input type="number" class="form-control" id="unit_qty" name="unit_qty" value="<?php echo e($service->unit_qty); ?>">
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="vat_rate" class="form-label fw-bold">VAT(%)</label>
                                        <input type="number" class="form-control" id="vat_rate" name="vat_rate" value="<?php echo e($service->vat_rate); ?>">
                                      </div>
                                    </div>
                                  </div>

                                  <div class="row">
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="rate_amnt" class="form-label fw-bold">Contact Amount</label>
                                        <input type="number" class="form-control" id="rate_amnt" name="rate_amnt" value="<?php echo e($service->rate_amnt); ?>">
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="vat_amnt" class="form-label fw-bold">VAT Amount</label>
                                        <input type="number" class="form-control" id="vat_amnt" name="vat_amnt" value="<?php echo e($service->vat_amnt); ?>">
                                      </div>
                                    </div>
                                  </div>
                                </fieldset>

                                
                                <fieldset class="border rounded-3 p-3 theme-border">
                                  <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Billing Info</legend>
                                  <div class="row">
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="monthly_bill_data" class="form-label fw-bold">Monthly Bill </label>
                                        <input type="text" class="form-control" id="monthly_bill_data" name="monthly_bill_data" value="<?php echo e($service->monthly_bill); ?>">
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <br>
                                      <div class="mt-3">
                                        <input type="hidden" name="include_vat_data" value="0">
                                        <input type="checkbox" class="form-check-input" id="include_vat_data" name="include_vat_data" <?php echo e($service->include_vat == 1?'checked':''); ?> value="1">
                                        <label for="include_vat_data" class="form-label fw-bold ms-1">Include VAT </label>
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="bill_start_date_data" class="form-label fw-bold">Bill Start Date</label>
                                        <input type="text" class="form-control datepicker-here digits" id="bill_start_date_data" name="bill_start_date_data" value="<?php echo e($service->bill_start_date); ?>">
                                      </div>
                                    </div>
                                  </div>

                                  <div class="row">
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="tbl_bill_type_id_data" class="form-label fw-bold">Bill Type</label>
                                        <select name="tbl_bill_type_id_data" id="tbl_bill_type_id_data" class="form-control">
                                          <option value="">Select a Bill Type</option>
                                          <?php $__currentLoopData = $bill_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bill_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                              <option <?php echo e(($service->tbl_bill_type_id == $bill_type->id) ? "selected" : ""); ?> value="<?php echo e($bill_type->id); ?>"><?php echo e($bill_type->bill_type_name); ?></option>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="tbl_status_type_id_data" class="form-label fw-bold">Service Status </label>
                                        <select name="tbl_status_type_id_data" id="tbl_status_type_id_data" class="form-control">
                                          <option value="">Select a Service Status</option>
                                          <?php $__currentLoopData = $status_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                              <option <?php echo e(($service->tbl_status_type_id == $status_type->id) ? "selected" : ""); ?> value="<?php echo e($status_type->id); ?>"><?php echo e($status_type->inv_name); ?></option>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="remarks_data" class="form-label fw-bold">Remarks / Special Note </label>
                                        <textarea class="form-control" id="remarks_data" name="remarks_data" rows="1"><?php echo e($service->remarks); ?></textarea>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="row">
                                    <div class="col-sm-4">
                                      <br>
                                      <div class="mt-3">
                                        <input type="hidden" name="greeting_sms_sent_data" value="0">
                                        <input type="checkbox" class="form-check-input" id="greeting_sms_sent_data" name="greeting_sms_sent_data" <?php echo e($service->greeting_sms_sent == 1?'checked':''); ?> value="1">
                                        <label for="greeting_sms_sent_data" class="form-label fw-bold ms-1">Send Greeting SMS? </label>
                                      </div>
                                    </div>
                                  </div>
                                </fieldset>
                              </fieldset>

                              
                              <fieldset class="border rounded-3 p-3 theme-border d-none" id="edit_broadband<?php echo e($service->srv_type_id); ?>">
                                <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Broadband</legend>
                                
                                <fieldset class="border rounded-3 p-3 theme-border mb-5">
                                  <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Service Info</legend>
                                  <div class="row">
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="user_id" class="form-label fw-bold">Customer ID  </label>
                                        <input type="text" class="form-control" id="user_id" name="user_id" value="<?php echo e($service->user_id); ?>">
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="password" class="form-label fw-bold">Password </label>
                                        <input type="password" class="form-control" id="password" name="password" value="<?php echo e($service->password); ?>">
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="bandwidth_plan_id" class="form-label fw-bold">Connection Type </label>
                                        <select name="bandwidth_plan_id" id="bandwidth_plan_id" class="form-control">
                                          <?php $__currentLoopData = $bandwidth_plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bandwidth_plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                              <option <?php echo e(($service->bandwidth_plan_id == $bandwidth_plan->id) ? "selected" : ""); ?> value="<?php echo e($bandwidth_plan->id); ?>"><?php echo e($bandwidth_plan->bandwidth_plan); ?></option>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="row">
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="installation_date" class="form-label fw-bold">Installation Date </label>
                                        <input type="text" class="form-control datepicker-here digits" id="installation_date" name="installation_date" value="<?php echo e($service->installation_date); ?>">
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="remarks_broadband" class="form-label fw-bold">Remarks / Special Note </label>
                                        <textarea class="form-control" id="remarks_broadband" name="remarks_broadband" rows="1"><?php echo e($service->remarks); ?></textarea>
                                      </div>
                                    </div>
                                  </div>
                                </fieldset>
                              
                                
                                <fieldset class="border rounded-3 p-3 theme-border mb-5">
                                  <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Connection Info</legend>
                                  <div class="row">
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="type_of_connectivity" class="form-label fw-bold">Type of Connectivity</label>
                                        <select name="type_of_connectivity" id="type_of_connectivity" class="form-control">
                                          <?php $__currentLoopData = $cable_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cable_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                              <option <?php echo e(($service->type_of_connectivity == $cable_type->id) ? "selected" : ""); ?> value="<?php echo e($cable_type->id); ?>"><?php echo e($cable_type->cable_type); ?></option>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="router_id" class="form-label fw-bold">Router</label>
                                        <select name="router_id" id="router_id" class="form-control">
                                          <?php $__currentLoopData = $routers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $router): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                              <option <?php echo e(($service->router_id == $router->id) ? "selected" : ""); ?> value="<?php echo e($router->id); ?>"><?php echo e($router->router_name); ?></option>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="device" class="form-label fw-bold">Device </label>
                                        <input type="text" class="form-control" id="device" name="device" value="<?php echo e($service->device); ?>">
                                      </div>
                                    </div>
                                  </div>

                                  <div class="row">
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="mac_address" class="form-label fw-bold">Device MAC </label>
                                        <input type="text" class="form-control" id="mac_address" name="mac_address" value="<?php echo e($service->mac_address); ?>">
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="ip_number" class="form-label fw-bold">IP Number</label>
                                        <input type="text" class="form-control" id="ip_number" name="ip_number" value="<?php echo e($service->ip_number); ?>">
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="box_id" class="form-label fw-bold">Box </label>
                                        <select name="box_id" id="box_id" class="form-control">
                                          <?php $__currentLoopData = $boxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $box): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                              <option <?php echo e(($service->box_id == $box->id) ? "selected" : ""); ?> value="<?php echo e($box->id); ?>"><?php echo e($box->box_name); ?></option>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="row">
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="cable_req" class="form-label fw-bold">Cable req </label>
                                        <input type="text" class="form-control" id="cable_req" name="cable_req" value="<?php echo e($service->cable_req); ?>">
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="no_of_core" class="form-label fw-bold">No. of Core </label>
                                        <input type="text" class="form-control" id="no_of_core" name="no_of_core" value="<?php echo e($service->no_of_core); ?>">
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="core_color" class="form-label fw-bold">Core Color </label>
                                        <input type="text" class="form-control" id="core_color" name="core_color" value="<?php echo e($service->core_color); ?>">
                                      </div>
                                    </div>
                                  </div>
                                      
                                  <div class="row">
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="fiber_code" class="form-label fw-bold">Fiber Code </label>
                                        <input type="text" class="form-control" id="fiber_code" name="fiber_code" value="<?php echo e($service->fiber_code); ?>">
                                      </div>
                                    </div>
                                  </div>
                                </fieldset>

                                
                                <fieldset class="border rounded-3 p-3 theme-border">
                                  <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Billing Info</legend>
                                  <div class="row">
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="tbl_bill_type_id_broadband" class="form-label fw-bold">Bill Type</label>
                                        <select name="tbl_bill_type_id_broadband" id="tbl_bill_type_id_broadband" class="form-control">
                                          <?php $__currentLoopData = $bill_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bill_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                              <option <?php echo e(($service->tbl_bill_type_id == $bill_type->id) ? "selected" : ""); ?> value="<?php echo e($bill_type->id); ?>"><?php echo e($bill_type->bill_type_name); ?></option>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="invoice_type_id" class="form-label fw-bold">Invoice Type </label>
                                        <select name="invoice_type_id" id="invoice_type_id" class="form-control" disabled>
                                          <option value="">Select an Invoice Type</option>
                                          <?php $__currentLoopData = $invoice_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                              <option <?php echo e(($service->invoice_type_id == $invoice_type->id) ? "selected" : ""); ?> value="<?php echo e($invoice_type->id); ?>"><?php echo e($invoice_type->invoice_type_name); ?></option>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="bill_start_date_broadband" class="form-label fw-bold">Bill Start Date</label>
                                        <input type="text" class="form-control datepicker-here digits" id="bill_start_date_broadband" name="bill_start_date_broadband" value="<?php echo e($service->bill_start_date); ?>">
                                      </div>
                                    </div>
                                  </div>

                                  <div class="row">
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="tbl_client_type_id" class="form-label fw-bold">Package </label>
                                        <select name="tbl_client_type_id" id="tbl_client_type_id" class="form-control">
                                          <?php $__currentLoopData = $client_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                              <option <?php echo e(($service->tbl_client_type_id == $client_type->id) ? "selected" : ""); ?> value="<?php echo e($client_type->id); ?>"><?php echo e($client_type->name); ?></option>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="monthly_bill_broadband" class="form-label fw-bold">Monthly Bill </label>
                                        <input type="text" class="form-control" id="monthly_bill_broadband" name="monthly_bill_broadband" value="<?php echo e($service->monthly_bill); ?>">
                                      </div>
                                    </div>
                                    
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="billing_status_id" class="form-label fw-bold">Billing Status </label>
                                        <select name="billing_status_id" id="billing_status_id" class="form-control">
                                          <?php $__currentLoopData = $billing_statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $billing_status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                              <option <?php echo e(($service->billing_status_id == $billing_status->id) ? "selected" : ""); ?> value="<?php echo e($billing_status->id); ?>"><?php echo e($billing_status->billing_status_name); ?></option>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="row">
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="tbl_status_type_id_broadband" class="form-label fw-bold">Service Status </label>
                                        <select name="tbl_status_type_id_broadband" id="tbl_status_type_id_broadband" class="form-control">
                                          <?php $__currentLoopData = $status_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                              <option <?php echo e(($service->tbl_status_type_id == $status_type->id) ? "selected" : ""); ?> value="<?php echo e($status_type->id); ?>"><?php echo e($status_type->inv_name); ?></option>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <br>
                                      <div class="mt-3">
                                        <input type="hidden" name="include_vat_broadband" value="0">
                                        <input type="checkbox" class="form-check-input" id="include_vat_broadband" name="include_vat_broadband" <?php echo e($service->include_vat == 1?'checked':''); ?> value="1">
                                        <label for="include_vat_broadband" class="form-label fw-bold ms-1">Include VAT </label>
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <br>
                                      <div class="mt-3">
                                        <input type="hidden" name="greeting_sms_sent_broadband" value="0">
                                        <input type="checkbox" class="form-check-input" id="greeting_sms_sent_broadband" name="greeting_sms_sent_broadband" <?php echo e($service->greeting_sms_sent == 1?'checked':''); ?> value="1">
                                        <label for="greeting_sms_sent_broadband" class="form-label fw-bold ms-1">Send Greeting SMS? </label>
                                      </div>
                                    </div>
                                  </div>
                                </fieldset>
                              </fieldset>

                              
                              <fieldset class="border rounded-3 p-3 theme-border d-none" id="edit_cable_tv<?php echo e($service->srv_type_id); ?>">
                                <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Cable TV</legend>
                                
                                <fieldset class="border rounded-3 p-3 theme-border mb-5">
                                  <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Service Info</legend>
                                  <div class="row">
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="number_of_tv" class="form-label fw-bold">Number of TV</label>
                                        <input type="text" class="form-control" id="number_of_tv" name="number_of_tv" value="<?php echo e($service->number_of_tv); ?>">
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="number_of_channel" class="form-label fw-bold">Number of Channel</label>
                                        <input type="text" class="form-control" id="number_of_channel" name="number_of_channel" value="<?php echo e($service->number_of_channel); ?>">
                                      </div>
                                    </div>
                                  </div>
                                </fieldset>

                                
                                <fieldset class="border rounded-3 p-3 theme-border">
                                  <legend class="float-none w-auto px-3 theme-text fs-5 fw-semibold">Billing Info</legend>
                                  <div class="row">
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="monthly_bill_cable" class="form-label fw-bold">Monthly Bill </label>
                                        <input type="text" class="form-control" id="monthly_bill_cable" name="monthly_bill_cable" value="<?php echo e($service->monthly_bill); ?>">
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <br>
                                      <div class="mt-3">
                                        <input type="hidden" name="include_vat_cable" value="0">
                                        <input type="checkbox" class="form-check-input" id="include_vat_cable" name="include_vat_cable" value="1" <?php echo e($service->include_vat == 1?'checked':''); ?>>
                                        <label for="include_vat_cable" class="form-label fw-bold ms-1">Include VAT </label>
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="bill_start_date_cable" class="form-label fw-bold">Bill Start Date</label>
                                        <input type="text" class="form-control datepicker-here digits" id="bill_start_date_cable" name="bill_start_date_cable" value="<?php echo e($service->bill_start_date); ?>">
                                      </div>
                                    </div>
                                  </div>

                                  <div class="row">
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="tbl_bill_type_id_cable" class="form-label fw-bold">Bill Type</label>
                                        <select name="tbl_bill_type_id_cable" id="tbl_bill_type_id_cable" class="form-control">
                                          <option value="">Select a Bill Type</option>
                                          <?php $__currentLoopData = $bill_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bill_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                              <option <?php echo e(($service->tbl_bill_type_id == $bill_type->id) ? "selected" : ""); ?> value="<?php echo e($bill_type->id); ?>"><?php echo e($bill_type->bill_type_name); ?></option>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="tbl_status_type_id_cable" class="form-label fw-bold">Service Status </label>
                                        <select name="tbl_status_type_id_cable" id="tbl_status_type_id_cable" class="form-control">
                                          <option value="">Select a Service Status</option>
                                          <?php $__currentLoopData = $status_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                              <option <?php echo e(($service->tbl_status_type_id == $status_type->id) ? "selected" : ""); ?> value="<?php echo e($status_type->id); ?>"><?php echo e($status_type->inv_name); ?></option>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                      </div>
                                    </div>
                                    <div class="col-sm-4">
                                      <div class="mb-2">
                                        <label for="remarks_cable" class="form-label fw-bold">Remarks / Special Note </label>
                                        <textarea class="form-control" id="remarks_cable" name="remarks_cable" rows="1"><?php echo e($service->remarks); ?></textarea>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="row">
                                    <div class="col-sm-4">
                                      <br>
                                      <div class="mt-3">
                                        <input type="hidden" name="greeting_sms_sent_cable" value="0">
                                        <input type="checkbox" class="form-check-input" id="greeting_sms_sent_cable" name="greeting_sms_sent_cable" <?php echo e($service->greeting_sms_sent == 1?'checked':''); ?> value="1">
                                        <label for="greeting_sms_sent_cable" class="form-label fw-bold ms-1">Send Greeting SMS? </label>
                                      </div>
                                    </div>
                                  </div>
                                </fieldset>
                              </fieldset>
                            </div>
                            <div class="modal-footer">
                              <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal" aria-label="Close">Cancel</button>
                              <button class="btn btn-sm btn-success" type="submit" onclick="this.disabled=true;this.form.submit();">Submit</button>
                            </div>
                          </form>
                        </div>
                      </div>
                    </div>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php $__env->startPush('select2'); ?>
    <script>
        $(document).ready(function() {
            $('.select2').select2({
                
            });
        });

        function addServices(select){
          let dataSection = document.getElementById('add_data');
          let broadbandSection = document.getElementById('add_broadband');
          let cableTvSection = document.getElementById('add_cable_tv');

          if(select.value==1){
            dataSection.classList.remove("d-none");
            broadbandSection.classList.add("d-none");
            cableTvSection.classList.add("d-none");
          } else if (select.value==2){
            broadbandSection.classList.remove("d-none");
            dataSection.classList.add("d-none");
            cableTvSection.classList.add("d-none");
          } else if (select.value==3){
            cableTvSection.classList.remove("d-none");
            dataSection.classList.add("d-none");
            broadbandSection.classList.add("d-none");
          }
        }

        function editServices(serviceId){
          let select = document.getElementById('srv_type_id' + serviceId).value;
          let dataSection = document.getElementById('edit_data'+ serviceId);
          let broadbandSection = document.getElementById('edit_broadband' + serviceId);
          let cableTvSection = document.getElementById('edit_cable_tv' + serviceId);

          if(select==1){
            dataSection.classList.remove("d-none");
            broadbandSection.classList.add("d-none");
            cableTvSection.classList.add("d-none");
          } else if (select==2){
            broadbandSection.classList.remove("d-none");
            dataSection.classList.add("d-none");
            cableTvSection.classList.add("d-none");
          } else if (select==3){
            cableTvSection.classList.remove("d-none");
            dataSection.classList.add("d-none");
            broadbandSection.classList.add("d-none");
          }
        }
    </script>
  <?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.main", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Dev\Documents\GitHub\mybillingnew\resources\views/pages/company/customers/services_info.blade.php ENDPATH**/ ?>