<?php $__env->startSection('main-container'); ?>
<style>
    .table th,
    .table td {
        padding: 0.25rem;
    }

    .select2-container .select2-selection--single {
        height: auto !important;
    }

    .select2-container .select2-selection--single .select2-selection__rendered {
        padding-top: .25rem !important;
        padding-bottom: .25rem !important;
        font-size: .875rem !important;
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow {
        top: 3px !important;
        right: 3px !important;
    }

    .select2-container--default .select2-selection--single .select2-selection__rendered {
        line-height: 1.5 !important;
    }
</style>
<div>
    <?php if(Session::has('success')): ?>
        <div class="alert alert-success alert-dismissible my-1" role="alert">
            <button type="button" class="close" data-bs-dismiss="alert">
                <i class="fa fa-times"></i>
            </button>
            <strong>Success !</strong> <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger alert-dismissible my-1" role="alert">
            <button type="button" class="close" data-bs-dismiss="alert">
                <i class="fa fa-times"></i>
            </button>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <strong>Error !</strong> <?php echo e($error); ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>
</div>

<div class="main_content_iner">
    <form action="<?php echo e(route('bulkrouterchange.show')); ?>" method="get" enctype="multipart/form-data" id="frm">
        <?php echo csrf_field(); ?>
        <div class="container-fluid p-0 sm_padding_15px">
            <div class="">
                <div class="px-4 py-1 theme_bg_1">
                    <h5 class="mb-0 text-white">Bulk Router Change</h5>
                </div>
            </div>

            <div class="row p-3">
                <div class="col-sm-4 form-group">
                    <label for="router" class="fw-medium">Router</label>
                    <select class="select2 form-select form-select-sm form-control" aria-label="Small select example" id="router" name="router">
                        <option value="-1" selected>Select a Router</option>
                        <?php $__currentLoopData = $routers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $router): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($router->id); ?>"><?php echo e($router->router_name); ?> -> <?php echo e($router->router_ip); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-sm-4 form-group">
                    <label for="package" class="fw-medium">Package</label>
                    <select class="select2 form-select form-select-sm form-control" id="package" name="package">
                        <option value="-1" selected>Select a Package</option>
                        <?php $__currentLoopData = $client_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($package->id); ?>"><?php echo e($package->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                      
                    </select>
                </div>

                <div class="col-sm-4 form-group">
                    <label for="zone" class="fw-medium">Zone</label>
                    <select class="select2 form-select form-select-sm form-control" id="zone" name="zone">
                        <option value="-1" selected>Select a Zone</option>
                        <?php $__currentLoopData = $zones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $zone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($zone->id); ?>"><?php echo e($zone->zone_name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                      
                    </select>
                </div>

                <div class="col-sm-4 form-group">
                    <label for="client_type" class="fw-medium">Client Type</label>
                    <select class="form-select form-select-sm form-control" id="client_type" name="client_type">
                        <option value="-1" selected>Select a Client Type</option>
                        <?php $__currentLoopData = $client_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($client_category->id); ?>"><?php echo e($client_category->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                      
                    </select>
                </div>

                <div class="col-sm-4 form-group">
                    <label for="status" class="fw-medium">Status</label>
                    <select class="form-select form-select-sm form-control" id="status" name="status">
                        <option value="-1" selected>Select a Status</option>
                        <?php $__currentLoopData = $status_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($status->id); ?>"><?php echo e($status->inv_name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                      
                    </select>
                </div>

                <div class="col-sm-2 form-group d-flex d-sm-inline justify-content-end">
                    <br class="d-none d-sm-block">
                    <button type="button" id="submitBtn" class="btn btn-sm btn-primary"><i class="fa-solid fa-magnifying-glass me-1"></i>Search</button>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
    $(document).ready(function() {
        $('.select2').select2({
            
        })
    });

    document.getElementById('submitBtn').addEventListener('click', function (e) {
        let router = document.getElementById('router').value;
        
        let submitBtn = document.getElementById('submitBtn');
        
        if(router=="-1")
        {
            alert("Select a router first!");
            e.preventDefault();
        } 
        else
        {
            submitBtn.disabled=true;
            document.getElementById("frm").submit();
        }
    });

    document.addEventListener('DOMContentLoaded', function () {
        const selectAllCheckbox = document.getElementById('selectAll');
        const checkboxes = document.querySelectorAll('.checkbox-to-select');

        selectAllCheckbox.addEventListener('change', function () {
            checkboxes.forEach(function (checkbox) {
                checkbox.checked = selectAllCheckbox.checked;
            });
        });

        checkboxes.forEach(function (checkbox) {
            checkbox.addEventListener('change', function () {
                if (!this.checked) {
                    selectAllCheckbox.checked = false;
                }
            });
        });
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/mcn/resources/views/pages/radius/bulkRouterChange.blade.php ENDPATH**/ ?>