<?php $__env->startSection('main-container'); ?>
<style>
    .table th,
    .table td {
        padding: 0.25rem;
    }

    .select2-container .select2-selection--single {
        height: auto !important;
    }

    .select2-container .select2-selection--single .select2-selection__rendered {
        padding-top: .25rem !important;
        padding-bottom: .25rem !important;
        font-size: .875rem !important;
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow {
        top: 3px !important;
        right: 3px !important;
    }

    .select2-container--default .select2-selection--single .select2-selection__rendered {
        line-height: 1.5 !important;
    }
</style>

<div>
    <?php if(Session::has('success')): ?>
        <div class="alert alert-success alert-dismissible my-1" role="alert">
            <button type="button" class="close" data-bs-dismiss="alert">
                <i class="fa fa-times"></i>
            </button>
            <strong>Success !</strong> <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger alert-dismissible my-1" role="alert">
            <button type="button" class="close" data-bs-dismiss="alert">
                <i class="fa fa-times"></i>
            </button>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <strong>Error !</strong> <?php echo e($error); ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>
</div>

<div class="main_content_iner">
	<div class="container-fluid p-0 sm_padding_15px">
		<div class="px-4 py-1 theme_bg_1">
			<div class="d-flex justify-content-between align-items-center">
				<h5 class="mb-0" style="color: white;">Invoice Collection</h5>
			</div>
		</div>

		<div class="row p-3">
			<div class="col-sm-4 form-group">
				<label for="client" class="fw-medium">Client</label>
				<select class="select2 form-select form-select-sm" id="client" name="client">
					<option selected>Select a Client</option>
					<?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<option value="<?php echo e($customer->customer_name); ?>"><?php echo e($customer->customer_name); ?> | <?php echo e($customer->mobile1); ?> | <?php echo e($customer->ac_no); ?> | <?php echo e($customer->id); ?></option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                   
				</select>
			</div>

			<div class="col-sm-2 form-group d-flex d-sm-inline justify-content-end">
				<br class="d-none d-sm-block">
				<button type="button" class="btn btn-sm btn-primary"  onclick="this.disabled=true;this.form.submit();">Show Data</button>
			</div>
		</div>

		<div class="QA_table p-3 pb-0">
			<?php
				$count  = 1;
			?>
			<div class="table-responsive">
				<table class="table">
					<thead>
						<tr style="border-bottom: 1px solid black;">
							<th colspan="11" class="text-center">Invoice List</th>
						</tr>
						<tr>
							<th scope="col">Invoice No.</th>
							<th scope="col">Type & Service</th>
							<th scope="col">Date</th>
							<th scope="col">Net Bill</th>
							<th scope="col">Received Amnt.</th>
							<th scope="col">Accept</th>
							<th scope="col">Amount</th>
							<th scope="col">Discount</th>
							<th scope="col">Vat</th>
							<th scope="col">AIT</th>
							<th scope="col">Down Time</th>
						</tr>
					</thead>

					<tbody>
						<?php
							$totalReceivedAmount = 0;
						?>

						<?php $__currentLoopData = $mas_invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mas_invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<?php
							$ReceivedAmount = ($mas_invoice->collection_amnt) + ($mas_invoice->discount_amnt) + ($mas_invoice->ait_adjustment) + ($mas_invoice->vat_adjust_ment) + ($mas_invoice->otheradjustment) + ($mas_invoice->downtimeadjust); 
							$totalReceivedAmount += $ReceivedAmount;
						?>
						<tr>
							<td><?php echo e($mas_invoice->invoice_number); ?></td>
							<td><?php echo e($mas_invoice->invoice_cat); ?> <?php echo e($mas_invoice->TblSrvType->srv_name); ?></td>
							<td><?php echo e($mas_invoice->invoice_date); ?></td>
							<td><input type="text" class="form-control form-control-sm" value="<?php echo e(number_format( $mas_invoice->total_bill, 2, '.', ',')); ?>" name="" disabled></td>
							<td><input type="text" class="form-control form-control-sm" id="received_amount" value="<?php echo e(number_format($totalReceivedAmount, 2, '.', ',')); ?>" name="" disabled></td>
							<td class="text-center"><input type='checkbox' class="form-check-input" id="accept" value='on' name='chkAccept[$i]' onclick="getAmount($i)"></td>
							<td><input type='number' class='form-control form-control-sm' id="amount" onchange='calculateTotalAmount()' value='0'></td>
							<td><input type='number' class='form-control form-control-sm' onchange='calculateTotalAmount1()' value='0'></td>
							<td><input type='number' class='form-control form-control-sm' onchange='calculateTotalAmount2()' value='0'></td>
							<td><input type='number' class='form-control form-control-sm' onchange='calculateTotalAmount3()' value='0'></td>
							<td><input type='number' class='form-control form-control-sm' onchange='calculateTotalAmount4()' value='0'></td>
						</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<tr>
							<td></td>
							<td></td>
							<td></td>
							<td colspan="3" class="text-end">Total Amount</td>
							<td><input type="text" class="form-control form-control-sm" value="0" name='txtTotalAmount' disabled></td>
							<td><input type="text" class="form-control form-control-sm" value="0" name='txtTotalDiscount' disabled></td>
							<td><input type="text" class="form-control form-control-sm" value="0" name='txtTotalVat' disabled></td>
							<td><input type="text" class="form-control form-control-sm" value="0" name='txtTotalAit' disabled></td>
							<td><input type="text" class="form-control form-control-sm" value="0" name='txtTotalDownTime' disabled></td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>

		<div class="QA_table p-3 pb-0">
			<div class="table-responsive">
				<table class="table">
					<thead>
						<tr class="text-center">
							<th scope="col" colspan="4">Received Detail</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<th scope="col">Receive Type</th>
							<td>
								<div class="">
									<div class="form-check form-check-inline">
										<label class="form-check-label" for="cash">Cash</label>
										<input class="form-check-input" type="radio" name="send_options" id="cash" value="option1" onchange="toggleChequeFields()">
									</div>
									<div class="form-check form-check-inline">
										<label class="form-check-label" for="cheque">Cheque</label>
										<input class="form-check-input" type="radio" name="send_options" id="cheque" value="option2" onchange="toggleChequeFields()">
									</div>
									<div class="form-check form-check-inline">
										<label class="form-check-label" for="directdiposit">Direct Diposit</label>
										<input class="form-check-input" type="radio" name="send_options" id="directdiposit" value="option3" onchange="toggleChequeFields()">
									</div>
								</div>
							</td>
							<th scope="col">Money Receipt No</th>
							<td><input type="text" class="form-control form-control-sm"></td>
						</tr>
						<tr>
							<th>Collection Date</th>
							<td>
								<div class="d-flex justify-content-between gap-3">
									<select name="day" id="day" class="form-select form-select-sm form-control">
										<option value="">Day</option>
										<?php $__currentLoopData = range(1, 31); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<option <?php echo e($dates->day == $day?'selected':''); ?> value="<?php echo e($day); ?>"><?php echo e($day); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
									<select name="month" id="month" class="form-select form-select-sm form-control">
										<option value="">Month</option>
										<?php $__currentLoopData = range(1,12); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<option <?php echo e($dates->month == $month?'selected':''); ?> value="<?php echo e(date("M", mktime(0, 0, 0, $month, 1))); ?>"><?php echo e(date("M", mktime(0, 0, 0, $month, 1))); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
									<select name="year" id="year" class="form-select form-select-sm form-control">
										<option value="">Year</option>
										<?php $__currentLoopData = range(now()->year - 15, now()->year + 5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<option <?php echo e($dates->year == $year?'selected':''); ?> value="<?php echo e($year); ?>"><?php echo e($year); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
								</div>
							</td>
							<th>Bank</th>
							<td>
								<select class="form-select form-select-sm form-control" id="bank" name="bank">
									<option selected>Select a Bank</option>
									<?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<option value="<?php echo e($bank->id); ?>"><?php echo e($bank->bank_name); ?></option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                   
								</select>
							</td>
						</tr>
						<tr>
							<th>Cheque No</th>
							<td><input type="text" class="form-control form-control-sm" id="chequeNo" disabled></td>
							<th>Cheque Date</th>
							<td>
								<div class="d-flex justify-content-between gap-3">
									<select name="day" id="day" class="form-select form-select-sm form-control">
										<option value="">Day</option>
										<?php $__currentLoopData = range(1, 31); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<option <?php echo e($dates->day == $day?'selected':''); ?> value="<?php echo e($day); ?>"><?php echo e($day); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
									<select name="month" id="month" class="form-select form-select-sm form-control">
										<option value="">Month</option>
										<?php $__currentLoopData = range(1,12); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<option <?php echo e($dates->month == $month?'selected':''); ?> value="<?php echo e(date("M", mktime(0, 0, 0, $month, 1))); ?>"><?php echo e(date("M", mktime(0, 0, 0, $month, 1))); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
									<select name="year" id="year" class="form-select form-select-sm form-control">
										<option value="">Year</option>
										<?php $__currentLoopData = range(now()->year - 15, now()->year + 5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<option <?php echo e($dates->year == $year?'selected':''); ?> value="<?php echo e($year); ?>"><?php echo e($year); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
								</div>
							</td>
						</tr>
						<tr>
							<th>Remarks</th>
							<td colspan="3"><textarea name="remarks" id="remarks" rows="2" class="form-control"></textarea></td>
						</tr>
						<tr>
							<td></td>
							<td colspan="3" class="py-3"><input type="checkbox" class="form-check-input me-1">SMS Notification</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>

		<div class="text-center">
			<button class="btn btn-sm btn-primary m-2 mb-3" onclick="this.disabled=true;this.form.submit();">Submit</button>
			<button class="btn btn-sm btn-primary m-2 mb-3" onclick="this.disabled=true;this.form.submit();">Submit & Print</button>
		</div>
	</div>
</div>

<?php $__env->startPush('select2'); ?>
<script>
    $(document).ready(function() {
        $('.select2').select2({
            
        });
    });

	function toggleChequeFields() {
		var chequeRadio = document.getElementById('cheque');
		var chequeNoInput = document.getElementById('chequeNo');
		var chequeDateDay = document.getElementById('cday');
		var chequeDateMonth = document.getElementById('cmonth');
		var chequeDateYear = document.getElementById('cyear');

		if (chequeRadio.checked) {
			chequeNoInput.disabled = false;
			chequeDateDay.disabled = false;
			chequeDateMonth.disabled = false;
			chequeDateYear.disabled = false;
		}
		else {
			chequeNoInput.disabled = true;
			chequeDateDay.disabled = true;
			chequeDateMonth.disabled = true;
			chequeDateYear.disabled = true;
		}
	}



	const receivedAmount = document.getElementById('received_amount').value;
	let amount = document.getElementById('amount').value;
	const acceptAmount = document.getElementById('accept');

	acceptAmount.addEventListener('change', function(){
		if (acceptAmount.checked){
			const checkboxValue = acceptAmount.value;
        	console.log("Checkbox value:", checkboxValue);
		}
	});

	console.log(amount);
</script>

<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/mcn/resources/views/pages/billing/invoiceCollection.blade.php ENDPATH**/ ?>