<?php $__env->startSection('main-container'); ?>
    <div>
        <?php if(Session::has('success')): ?>
            <div class="alert alert-success alert-dismissible my-1" role="alert">
                <button type="button" class="close" data-bs-dismiss="alert">
                    <i class="fa fa-times"></i>
                </button>
                <strong>Success !</strong> <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
    </div>

    <div class="main_content_iner mt-0">
            
        <div class="container-fluid p-0 sm_padding_15px">
            <div class="">
                <div class="px-4 py-1 theme_bg_1 d-flex justify-content-between">
                    <h5 class="mb-0 text-white text-center">Mikrotik Graph</h5>
                    <a class="btn-custom-1" href="#" data-bs-toggle="modal" data-bs-target="#addMikrotikModal">Add</a>
                </div>
            </div>

            <!-- Add Modal -->
            <div class="modal fade" id="addMikrotikModal" tabindex="-1" aria-labelledby="addMikrotikModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header theme_bg_1">
                            <h1 class="modal-title fs-5 text-white" id="addMikrotikModalLabel">Add New Mikrotik Graph</h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="filter: invert(100%);"></button>
                        </div>

                        <form class="" method="POST" action="<?php echo e(route('mikrotikgraph.store')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="modal-body">
                                <div class="mb-2 d-flex flex-column">
                                    <label for="router_id" class="form-label">Router </label>
                                    <select name="router_id" id="router_id" class="form-select">
                                        <option value="">Select a Router</option>
                                        <?php $__currentLoopData = $routers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $router): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($router->id); ?>"><?php echo e($router->router_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="mb-2 d-flex flex-column">
                                    <label for="interface" class="form-label">Interface </label>
                                    <select name="interface" id="interface" class="form-select">
                                        <option value="">Select an Interface</option>
                                        <?php $__currentLoopData = $routers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $router): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($router->lan_interface); ?>"><?php echo e($router->lan_interface); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="mb-2">
                                    <label for="allow_address" class="form-label">Allow Address </label>
                                    <input type="text" class="form-control border border-secondary" placeholder="0.0.0.0/0" id="allow_address" name="allow_address">
                                </div>
                                <div class="mb-2 d-flex flex-column">
                                    <label for="store_on" class="form-label">Store On Disk </label>
                                    <select name="store_on" id="store_on" class="form-select">
                                        <option value="yes">yes</option>
                                        <option value="no">no</option>
                                    </select>
                                </div>
                                <div class="mb-2 d-flex flex-column">
                                    <label for="status" class="form-label">Status </label>
                                    <select name="status" id="status" class="form-select">
                                        <option value="1">Active</option>
                                        <option value="2">Inactive</option>
                                    </select>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">Close</button>
                                <input type="submit" class="btn btn-sm btn-primary" value="Submit" onclick="this.disabled=true;this.form.submit();">
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="QA_table p-3 pb-0">
                <table class="table">
                    <thead>
                        <tr>
                            <th scope="col">#SL</th>
                            <th scope="col">Router Name</th>
                            <th scope="col">Interface</th>
                            <th scope="col">Allow Address</th>
                            <th scope="col">Store On Disk</th>
                            <th scope="col">Status</th>
                            <th scope="col" class="text-center">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $slNumber = 1 ?>
                        <?php $__currentLoopData = $mikrotiks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mikrotik): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($slNumber++); ?></td>
                                <?php $__currentLoopData = $routers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $router): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($mikrotik->router_id == $router->id): ?>
                                        <td><?php echo e($router->router_name); ?></td>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <td><?php echo e($mikrotik->interface); ?></td>
                                <td><?php echo e($mikrotik->allow_address); ?></td>
                                <td><?php echo e($mikrotik->store_on); ?></td>
                                <td><?php echo e($mikrotik->status == 1 ? 'Active': 'Inactive'); ?></td>
                                <td class="text-center text-nowrap" width='10%'>
                                    <button type="button" class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#edit_mikrotik_modal-<?php echo e($mikrotik->id); ?>">Edit</button>
                                </td>
                            </tr>
                            
                            <!-- Edit Modal -->
                            <div class="modal fade" id="edit_mikrotik_modal-<?php echo e($mikrotik->id); ?>" tabindex="-1" aria-labelledby="editMikrotikModalLabel<?php echo e($mikrotik->id); ?>" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header theme_bg_1">
                                            <h1 class="modal-title fs-5 text-white" id="editMikrotikModalLabel<?php echo e($mikrotik->id); ?>">Edit Mikrotik</h1>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="filter: invert(100%);"></button>
                                        </div>
                                        <form class="" id="editForm" method="POST" action="<?php echo e(route('mikrotikgraph.update', ['mikrotikgraph' => $mikrotik])); ?>">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PUT'); ?>
                                            <div class="modal-body">
                                                <div class="mb-2 d-flex flex-column">
                                                    <label for="router_id" class="form-label">Router </label>
                                                    <select name="router_id" id="router_id" class="form-select">
                                                        <?php $__currentLoopData = $routers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $router): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option <?php echo e(($mikrotik->router_id == $router->id) ? "selected" : ""); ?> value="<?php echo e($router->id); ?>"><?php echo e($router->router_name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                                <div class="mb-2 d-flex flex-column">
                                                    <label for="interface" class="form-label">Interface </label>
                                                    <select name="interface" id="interface" class="form-select">
                                                        <?php $__currentLoopData = $routers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $router): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option <?php echo e(($mikrotik->interface == $router->lan_interface) ? "selected" : ""); ?> value="<?php echo e($router->lan_interface); ?>"><?php echo e($router->lan_interface); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                                <div class="mb-2">
                                                    <label for="allow_address" class="form-label">Allow Address </label>
                                                    <input type="text" class="form-control border border-secondary" placeholder="0.0.0.0/0" id="allow_address" name="allow_address" value="<?php echo e($mikrotik->allow_address); ?>">
                                                </div>
                                                <div class="mb-2 d-flex flex-column">
                                                    <label for="store_on" class="form-label">Store On Disk </label>
                                                    <select name="store_on" id="store_on" class="form-select">
                                                        <option <?php echo e(($mikrotik->store_on == "yes") ? "selected" : ""); ?> value="yes">Yes</option>
                                                        <option <?php echo e(($mikrotik->store_on == "no") ? "selected" : ""); ?> value="no">No</option>
                                                    </select>
                                                </div>
                                                <div class="mb-2 d-flex flex-column">
                                                    <label for="status" class="form-label">Status </label>
                                                    <select name="status" id="status" class="form-select">
                                                        <option <?php echo e(($mikrotik->status == "1") ? "selected" : ""); ?> value="1">Active</option>
                                                        <option <?php echo e(($mikrotik->status == "2") ? "selected" : ""); ?> value="2">Inactive</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">Close</button>
                                                <input type="submit" class="btn btn-sm btn-success" value="Submit" onclick="this.disabled=true;this.form.submit();">
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/mcn/resources/views/pages/setup/mikrotikGraph.blade.php ENDPATH**/ ?>