<?php $__env->startSection('main-container'); ?>
    <div class="main_content_iner mt-0">
        <div class="container-fluid p-0 sm_padding_15px">
            <div class="">
                <div class="px-4 py-1 theme_bg_1">
                    <h5 class="mb-0 text-white">Radius Report</h5>
                </div>
            </div>

            <form action="<?php echo e(route('accesslog.search')); ?>" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="row p-3">
                    <div class="col-sm-4 form-group">
                        <label class="fw-medium" for="start_date" class="form-label">From</label>
                        <input class="form-control input_form datepicker-here digits" name="start_date" id="start_date" data-date-Format="yyyy-mm-dd" value="<?php echo e($nowdate); ?>" placeholder="Start date">
                    </div>
                    <div class="col-sm-4 form-group">
                        <label class="fw-medium" for="end_date" class="form-label">To</label>
                        <input class="form-control input_form datepicker-here digits" name="end_date" id="end_date" data-date-Format="yyyy-mm-dd" value="<?php echo e($nowdate); ?>" placeholder="End date">
                    </div>
                    <div class="col-sm-4 form-group">
                        <label class="fw-medium" for="customer" class="form-label">Customer</label>
                        <select name="customer" id="customer" class="form-select form-control">
                            <option value="-1">Select a Customer</option>
                            <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option <?php echo e($selectedCustomer==$customer->id ? 'selected' : ''); ?> value="<?php echo e($customer->id); ?>"><?php echo e($customer->user_id); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-sm-4 form-group">
                        <label class="fw-medium" for="mac_address" class="form-label">Mac address</label>
                        <input type="text" name="mac_address" id="mac_address" value="<?php echo e($selectedMacAddress); ?>" placeholder="mac address" class="form-control">
                    </div>
                    <div class="col-sm-4 form-group">
                        <label class="fw-medium" for="ip_address" class="form-label">IP address</label>
                        <input type="text" name="ip_address" id="ip_address" value="<?php echo e($selectedIpAddress); ?>" placeholder="ip address" class="form-control">
                    </div>
                    <div class="col-sm-4 form-group">
                        <label class="fw-medium" for="nas" class="form-label">NAS</label>
                        <select name="nas" id="nas" class="form-select form-control">
                            <option value="-1" selected>Select a NAS</option>
                            <?php $__currentLoopData = $nas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ns): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option <?php echo e($selectedNas==$ns->id? 'selected' : ''); ?> value="<?php echo e($ns->id); ?>"><?php echo e($ns->shortname); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="d-flex justify-content-center gap-4">
                        <button type="button" class="btn btn-sm btn-info text-white" onclick="this.disabled=true;this.form.submit();"><i class="fa-sharp fa-solid fa-eye me-1"></i>View</button>
                        <button type="button" class="btn btn-sm btn-warning text-white" onclick="this.disabled=true;window.print()"><i class="fa-solid fa-print me-1"></i>Print</button>
                    </div>
                </div>
            </form>

            <div class="QA_table px-3 ">
                <?php if($radaccts->count()): ?>
                    <div class="table-responsive">
                        <table class="table ">
                            <thead>
                                <tr>
                                    <th scope="col"><small class="text-nowrap">ID</small></th>
                                    <th scope="col"><small class="text-nowrap">IP</small></th>
                                    <th scope="col"><small class="text-nowrap">Mac Address</small></th>
                                    <th scope="col"><small class="text-nowrap">NAS</small></th>
                                    <th scope="col"><small class="text-nowrap">Start Time</small></th>
                                    <th scope="col"><small class="text-nowrap">End Time</small></th>
                                    <th scope="col"><small class="text-nowrap">Download</small></th>
                                    <th scope="col"><small class="text-nowrap">Upload</small></th>
                                    <th scope="col"><small class="text-nowrap">Session Time</small></th>
                                    <th scope="col"><small class="text-nowrap">Termination Cause</small></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $radaccts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $radacct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($radacct->username); ?></td>
                                        <td><?php echo e($radacct->framedipaddress); ?></td>
                                        <td><?php echo e($radacct->callingstationid); ?></td>
                                        <td><?php echo e($radacct->nasipaddress); ?></td>
                                        <td><?php echo e($radacct->acctstarttime); ?></td>
                                        <td><?php echo e($radacct->acctstoptime); ?></td>
                                        <td><?php echo e($radacct->acctinputoctets/(131072*1024)); ?></td>
                                        <td><?php echo e($radacct->cctoutputoctets/(131072*1024)); ?></td>
                                        <td><?php echo e($radacct->acctsessiontime/60); ?></td>
                                        <td><?php echo e($radacct->acctterminatecause); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p>No records found.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/mcn/resources/views/pages/radius/accessLog.blade.php ENDPATH**/ ?>