<?php $__env->startSection('main-container'); ?>
<style>
    .table th,
    .table td {
        padding: 0.25rem;
    }
</style>

<div>
    <?php if(Session::has('success')): ?>
        <div class="alert alert-success alert-dismissible my-1" role="alert">
            <button type="button" class="close" data-bs-dismiss="alert">
                <i class="fa fa-times"></i>
            </button>
            <strong>Success !</strong> <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger alert-dismissible my-1" role="alert">
            <button type="button" class="close" data-bs-dismiss="alert">
                <i class="fa fa-times"></i>
            </button>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <strong>Error !</strong> <?php echo e($error); ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>
</div>

<div class="main_content_iner">
    <div class="container-fluid p-0 sm_padding_15px">
        <div class="px-4 py-1 theme_bg_1">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0" style="color: white;">Modify Invoice</h5>
            </div>
        </div>

        <div class="row p-3">
            <div class="col-sm-4 form-group">
                <label for="date" class="fw-medium">Select a Date</label>
                <div class="d-flex justify-content-between gap-3">
                    <select name="day" id="day" class="form-select form-select-sm form-control">
                        <option value="">Day</option>
                        <?php $__currentLoopData = range(1, 31); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php echo e($dates->day == $day?'selected':''); ?> value="<?php echo e($day); ?>"><?php echo e($day); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <select name="month" id="month" class="form-select form-select-sm form-control">
                        <option value="">Month</option>
                        <?php $__currentLoopData = range(1,12); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php echo e($dates->month == $month?'selected':''); ?> value="<?php echo e(date("M", mktime(0, 0, 0, $month, 1))); ?>"><?php echo e(date("M", mktime(0, 0, 0, $month, 1))); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <select name="year" id="year" class="form-select form-select-sm form-control">
                        <option value="">Year</option>
                        <?php $__currentLoopData = range(now()->year - 15, now()->year + 5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php echo e($dates->year == $year?'selected':''); ?> value="<?php echo e($year); ?>"><?php echo e($year); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>  

            <div class="col-sm-4 form-group">
				<label for="collector" class="fw-medium">Collector</label>
				<select class="form-select form-select-sm form-control" id="collector" name="collector">
					<option selected>Select a Collector</option>
					<?php $__currentLoopData = $nisl_mas_members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nisl_mas_member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<option value="<?php echo e($nisl_mas_member->id); ?>"><?php echo e($nisl_mas_member->username); ?></option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                   
				</select>
			</div>

            <div class="col-sm-4 form-group">
				<label for="client_type" class="fw-medium">Client Type</label>
				<select class="form-select form-select-sm form-control" id="client_type" name="client_type">
					<option selected>Select a Client Type</option>
					<?php $__currentLoopData = $client_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<option value="<?php echo e($client_category->id); ?>"><?php echo e($client_category->name); ?></option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                   
				</select>
			</div>

            <div class="col-sm-4 form-group">
				<label for="zone" class="fw-medium">Zone</label>
				<select class="form-select form-select-sm form-control" id="zone" name="zone">
					<option selected>Select a Zone</option>
					<?php $__currentLoopData = $zones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $zone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<option value="<?php echo e($zone->id); ?>"><?php echo e($zone->zone_name); ?></option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                   
				</select>
			</div>

            <div class="col-sm-4 form-group">
				<label for="branch" class="fw-medium">Branch</label>
				<select class="form-select form-select-sm form-control" id="branch" name="branch">
					<option selected>Select a Branch</option>
					<?php $__currentLoopData = $suboffices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $suboffice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<option value="<?php echo e($suboffice->id); ?>"><?php echo e($suboffice->name); ?></option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                   
				</select>
			</div>

            <div class="col-sm-2 form-group d-flex d-sm-inline justify-content-end">
                <br class="d-none d-sm-block">
                <button type="button" class="btn btn-sm btn-primary" onclick="this.disabled=true;this.form.submit();">Show Report</button>
            </div>

            <h5 class="text-center fs-5 text-dark mb-0">Daily Bill Collection Report</h5>

            <div class="QA_table p-3 pt-0 pb-0">
                <?php
                    $count  = 1;
                ?>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th scope="col">Sl</th>
                                <th scope="col">User ID</th>
                                <th scope="col">Clients Name</th>
                                <th scope="col">Money Rec. No.</th>
                                <th scope="col">Bank Name</th>
                                <th scope="col">Cheque No.</th>
                                <th scope="col">Cash(BDT)</th>
                                <th scope="col">Cheque(BDT)</th>
                                <th scope="col">Deposit(BDT)</th>
                                <th scope="col">Total(BDT)</th>
                                <th scope="col">Remarks</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/mcn/resources/views/pages/billing/dailyCollectionSheet.blade.php ENDPATH**/ ?>