<?php $__env->startSection('main-container'); ?>
    <div>
        <?php if(Session::has('success')): ?>
            <div class="alert alert-success alert-dismissible my-1" role="alert">
                <button type="button" class="close" data-bs-dismiss="alert">
                    <i class="fa fa-times"></i>
                </button>
                <strong>Success !</strong> <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible my-1" role="alert">
                <button type="button" class="close" data-bs-dismiss="alert">
                    <i class="fa fa-times"></i>
                </button>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <strong>Error !</strong> <?php echo e($error); ?>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>

    <div class="main_content_iner mt-0">
        <div class="container-fluid p-0 sm_padding_15px">

            <div class="mb-2">
                <div class="px-4 py-1 theme_bg_1">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0 text-white">Static IP</h5>
                        <a class="btn-custom-1" href="#" data-bs-toggle="modal" data-bs-target="#addipModal">Add</a>
                    </div>
                </div>
            </div>

            <!-- Add Modal -->
            <div class="modal fade" id="addipModal" tabindex="-1"
                aria-labelledby="addipModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header theme_bg_1">
                            <h1 class="modal-title fs-5 text-white" id="addipModalLabel">Add New ip</h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="filter: invert(100%);"></button>
                        </div>
                        <form method="POST" action="<?php echo e(route('staticip.store')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="modal-body">
                                <div class="mb-2">
                                    <label for="name" class="form-label">Name: </label>
                                    <input type="text" class="form-control" id="name" name="name">
                                </div>
                                <div class="mb-2">
                                    <label for="range" class="form-label">Range: </label>
                                    <input type="text" class="form-control" id="range" name="range">
                                </div>
                                <div class="mb-2">
                                    <label for="status" class="form-label">Status: </label>
                                    <select class="form-control" name="status" id="status">
                                        <option value="1">Active</option>
                                        <option value="2">Inactive</option>
                                    </select>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">Close</button>
                                <input type="submit" class="btn btn-sm btn-primary" value="Submit" onclick="this.disabled=true;this.form.submit();">
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="QA_table p-3 pb-0">
                <?php
                    $count  = 1;
                ?>
                <div class="table-responsive">
                    <table class="table datatable compact">
                        <thead>
                            <tr>
                                <th scope="col">Sl</th>
                                <th scope="col">Name</th>
                                <th scope="col">Range</th>
                                <th scope="col">Status</th>
                                <th scope="col" class="text-center">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $stat_ips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr style="height: 30px">
                                    <td style="color: black; font-size: small;"><?php echo e($count++); ?></td> 
                                    <td style="color: black; font-size: small;"><?php echo e($ip->name); ?></td>
                                    <td style="color: black; font-size: small;"><?php echo e($ip->range); ?></td>
                                    <td style="color: black; font-size: small;"><?php echo e($ip->status ==1 ? 'Active': 'Inactive'); ?></td>
                                    <td class="text-end text-nowrap" width='10%'>
                                        <button class="btn btn-success py-0" data-bs-toggle="modal" data-bs-target="#editipModal<?php echo e($ip->id); ?>">
                                            Edit
                                        </button>
                                        <button class="btn btn-danger py-0" data-bs-toggle="modal" data-bs-target="#deleteipModal<?php echo e($ip->id); ?>">
                                            Delete
                                        </button>
                                    </td>
                                </tr>
                                
                                <!-- Edit Modal -->
                                <div class="modal fade" id="editipModal<?php echo e($ip->id); ?>" tabindex="-1"
                                    aria-labelledby="editipModalLabel<?php echo e($ip->id); ?>" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header theme_bg_1">
                                                <h1 class="modal-title fs-5 text-white" id="editipModalLabel<?php echo e($ip->id); ?>">Edit ip</h1>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="Close" style="filter: invert(100%);"></button>
                                            </div>
                                            <form class="" id="editForm" method="POST" action="<?php echo e(route('staticip.update', ['staticip' => $ip])); ?>">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>
                                                <div class="modal-body">
                                                    <div class="mb-2">
                                                        <label for="name" class="form-label">Name: </label>
                                                        <input type="text" class="form-control" id="name" name="name" value="<?php echo e($ip->name); ?>">
                                                    </div>
                                                    <div class="mb-2">
                                                        <label for="range" class="form-label">Range: </label>
                                                        <input type="text" class="form-control" id="range" name="range" value="<?php echo e($ip->range); ?>">
                                                    </div>
                                                    <div class="mb-2">
                                                        <label for="status" class="form-label">Status: </label>
                                                        <select class="form-control" name="status" id="status">
                                                            <option value="1">Active</option>
                                                            <option value="2">Inactive</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">Close</button>
                                                    <input type="submit" class="btn btn-sm btn-success" value="Submit" onclick="this.disabled=true;this.form.submit();">
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>

                                <!-- Delete Modal -->
                                <div class="modal fade" id="deleteipModal<?php echo e($ip->id); ?>" tabindex="-1"
                                    aria-labelledby="deleteipModalLabel<?php echo e($ip->id); ?>" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header theme_bg_1">
                                                <h1 class="modal-title fs-5 text-white" id="deleteipModalLabel<?php echo e($ip->id); ?>">Delete <?php echo e($ip->name); ?>?</h1>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="Close" style="filter: invert(100%);"></button>
                                            </div>
                                            <form class="" id="editForm" method="POST" action="<?php echo e(route('staticip.destroy', ['staticip' => $ip])); ?>">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <div class="modal-body">
                                                    <div class="mb-2">
                                                        <label for="ip_name" class="form-label">Name: </label>
                                                        <input type="text" class="form-control" id="ip_name" name="ip_name" value="<?php echo e($ip->name); ?>" disabled>
                                                    </div>
                                                    <div>
                                                        <label for="ip_value" class="form-label">Range: </label>
                                                        <input type="text" class="form-control" id="ip_name" name="ip_name" value="<?php echo e($ip->range); ?>" disabled>
                                                    </div>
                                                    <div class="mb-2">
                                                        <label for="status" class="form-label">Status: </label>
                                                        <select class="form-control" name="status" id="status" disabled>
                                                            <option <?php echo e($ip->status == 1 ? 'selected' : ''); ?> value="1">Active</option>
                                                            <option <?php echo e($ip->status == 2 ? 'selected' : ''); ?> value="2">Inactive</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">Close</button>
                                                    <button class="btn btn-sm btn-danger" type="submit" onclick="this.disabled=true;this.form.submit();">Delete</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/mcn/resources/views/pages/radius/staticIp.blade.php ENDPATH**/ ?>